package apps.conf;

import cnrg.itx.signal.*;
import cnrg.itx.ds.*;

/**
 * Implements a desktopSignaling lookalike that creates a DesktopSignaling with no cleanup thread
 */
public class DirtyDesktopSignaling extends cnrg.itx.signal.DesktopSignaling { 
	

	public DirtyDesktopSignaling(SignalingObserver so, String uid, String pass) throws DirectoryServiceException{
		super(so,uid,pass);
	}
	
	public DirtyDesktopSignaling(SignalingObserver so, String uid, String pass, String desc, String config) throws DirectoryServiceException{
		super(so,uid,pass,desc,config);
	}
	
	public DirtyDesktopSignaling(SignalingObserver so, String uid, int port) {
		super(so,uid,port);
	}
	
	/** This method registers the DesktopSignaling Component with DirectoryService without spawining a cleanup thread.
	 * 
	 * @param   None.
	 * @return  Void.
	 */
	protected void Register() throws DirectoryServiceException {
		myDirS.setCleanUp(false);	//The big change is here -- turn off cleanup thread!
		myDirS.declareIdentity(myUID, myPassword);
		myDirS.registerLocation(Location.ROAMING, myLoc);			
	}
}
